const URI = "https://nadinegp2.000webhostapp.com/Nadeen/Signup/signUpController.php";
var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;

// expresion that checks on the email value that has valid emails
var emailblockReg =
    /^([\w-\.]+@(?!gmail.com)(?!yahoo.com)(?!hotmail.com)(?!GMAIL.COM)(?!YAHOO.COM)(?!HOTMAIL.COM)([\w-]+\.)+[\w-]{2,4})?$/;
var regExp = /[a-zA-Z]/g;
$(document).ready(function () {
    var today = new Date();
    // this function will be exeutend when we focus out of the email input
    $("#email").focusout(function () {
        // if the email dosn't match the experssion the system will show the message 
        if (emailblockReg.test($("#email").val())) {
            Swal.fire({
                icon: 'Error',
                title: 'Oops...',
                text: 'Please enter a valid email address!',
                                    confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
            }).then(function (isConfirm) {
                // when the user clicks on the ok button the system will focus in the email input again
                if (isConfirm) {
                    $("#email").focus()
                }
            });

        } else {
            // if the system matches the expression the system will send ajax request to check if the email already in use in the system or not 
            $.ajax({
                type: "POST",
                url: URI + '?action=checkemail',
                data: { email: $('#email').val() },
                success: function (response) {
                    // if the respons got back with the result that the email is registgered on the system
                    // the bellow message will show and when the user click on the ok button it will foucs in the email input again 
                    if (response == 'Registered') {
                        Swal.fire({
                            icon: 'Error',
                            title: 'Oops...',
                            text: 'The email is already registerd on the system!',
                                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
                        }).then(function (isConfirm) {
                            if (isConfirm) {
                                $("#email").focus()
                            }
                        })
                    }
                }
            });

        }
    })

    // this function will be executed when the value of the date of birth input changes
    $('#dateOfBirth').change(function () {
        // get today date 
        var today = new Date();
        // get the current  year
        var yyyy = today.getFullYear();

        // get the value enterd by the user in the date of birth input 
        var DOB = $(this).val();
        // convert the value into an array bu splitting it on the - 
        DOB = DOB.split('-');
        // get the user's input year
        var DOBYear = DOB[0];
        // spscract the current year from the user inut year
        var yearsDiffrent = yyyy - DOBYear;
        // if the year is less than 18 the system will reject it and show the message
        if (yearsDiffrent < 18) {
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Your Age should at least be 18 !',
                                    confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
            })
        }
        // if the year is less than 1992 ADN more than 2004  the system will reject it and show the message
        if (DOBYear < 1922 || DOBYear > 2004) {
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Please enter a valid Date!',
                                    confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
            })
        }

        console.log(DOB)
    })
    getNationality();
    getPositions();
});
$("#registerBtn").click(function (e) {

    // get the values of the inputs
    var firstName = $("#firstName").val();
    var lastName = $("#lastName").val();
    var password = $("#password").val();
    var confirmPassword = $("#confirmPassword").val();
    var phoneNumber = $("#phoneNumber").val();
    var position = $("#position").val();
    var dateOfBirth = $("#dateOfBirth").val();
    var gender = $("#gender").val();
    var email = $("#email").val();
    var emergencyName = $("#emergencyName").val();
    var emergencyPhoneNumber = $("#emergencyPhoneNumber").val();

    var personalID = $('#personalID').prop('files')[0];
    var passport = $('#passport').prop('files')[0];
    var universityCertificate = $('#universityCertificate').prop('files')[0];
    var nonCriminal = $('#nonCriminal').prop('files')[0];
    var medicalCertificate = $('#medicalCertificate').prop('files')[0];
    var cv = $('#CV').prop('files')[0];
    var iban = $('#IBAN').prop('files')[0];
    var recommendationLetter = $('#recommendationLetter').prop('files')[0];
    var other = $('#other').prop('files')[0];
    var signture = $('#sig-dataUrl').val();
    //end of gettin the values of the inputs
    
    const first3 = phoneNumber.substring(0, 3);

    const first3Emergency = emergencyPhoneNumber.substring(0, 3);

    // check that all the mandetory has a value
    if (!personalID || !passport || !universityCertificate || !nonCriminal || !medicalCertificate || !cv || !iban || !email || !firstName || !lastName || !password || !confirmPassword || !phoneNumber || !position || !dateOfBirth || !gender || !emergencyName || !emergencyPhoneNumber || !signture) {
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Please fill all the mandetory Fields!',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    } 
    // check id the value of password and confirm password are matching if not the system will show the below message
    else if (password != confirmPassword) {
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Password and Confirm Password should be match !',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
    // check if the password length is more than 8 charachter id not the system will show the below message
    else if (password.length < 8) {
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Password should at least be 8 chachters',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
    // check if the phoneNumber length is less than 10 charachter id not the system will show the below message
    else if(phoneNumber.length < 10){
            Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Phone number should be 10 digits!',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
        // check if the phoneNumber length is more than 10 charachter id not the system will show the below message
    else if (phoneNumber.length > 10){
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Phone number should be 10 digits!',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
    // check the first three charachters from the phone
    else if(first3 != '079' && first3 != '077' && first3 != '078'){
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Phone number should start with 079 or 078 or 077',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }else if(regExp.test(phoneNumber)){
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Phone number should contains only numbers',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
    else if(emergencyPhoneNumber.length < 10){
            Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Emergency phone number should be 10 digits!',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
        // check if the phoneNumber length is more than 10 charachter id not the system will show the below message
    else if (emergencyPhoneNumber.length > 10){
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Emergency phone number should be 10 digits!',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
    // check the first three charachters from the phone
    else if(first3Emergency != '079' && first3Emergency != '077' && first3Emergency != '078'){
        Swal.fire({
            icon: 'Error',
            title: 'Oops...',
            text: 'Emergency phone number should start with 079 or 078 or 077',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }else if(regExp.test(emergencyPhoneNumber)){
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Emergency phone number should contains only numbers',
                                confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
        })
    }
    // if all the validation are okay then will prepare the data to send to the backend
    else {

        var form_data = new FormData();

        // add the data for the document signture and input to the form data
        form_data.append('personalID', personalID);
        form_data.append('passport', passport);
        form_data.append('universityCertificate', universityCertificate);
        form_data.append('nonCriminal', nonCriminal);
        form_data.append('medicalCertificate', medicalCertificate);
        form_data.append('cv', cv);
        form_data.append('iban', iban);
        if(recommendationLetter){
            form_data.append('recommendationLetter', recommendationLetter);
        }
        if(other){
            form_data.append('other', other);
        }

        form_data.append('firstName', firstName);
        form_data.append('lastName', lastName);
        form_data.append('password', password);
        form_data.append('confirmPassword', confirmPassword);
        form_data.append('phoneNumber', phoneNumber);
        form_data.append('position', position);
        form_data.append('dateOfBirth', dateOfBirth);
        form_data.append('gender', gender);
        form_data.append('email', email);
        form_data.append('emergencyName', emergencyName);
        form_data.append('emergencyPhoneNumber', emergencyPhoneNumber);
        form_data.append('signture', signture);
        // end of adding the data for the document signture and input to the form data
        $.ajax({
            type: "POST",
            url: URI + '?action=signUpUser',
            // send the data with the ajax request
            data: form_data,
            processData: false,
            contentType: false,
            success: function (response) {
                // if the user is registerd successfully the below message, when the user clicks on the ok button the system will reload the page
                if (response == 'Registered') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Great',
                        text: 'Registered successfully, please wait the approval from the HR',
                                            confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
                    }).then(function (isConfirm) {
                        if (isConfirm) {
                            location.reload();
                        }
                    });
                } else {
                // if the user isn't registerd successfully the below message

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'An error occurred please try again!',
                                            confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
                    })
                }


            }
        });
    }

});
function getNationality() {
    var Nationality_Select = $('#nationality');

    $.ajax({
        type: "POST",
        url: URI + '?action=getNationality',
        dataType: "JSON",
        success: function (response) {
            data = response.data;
            data.forEach(element => {
                Nationality_Select.append(`<option value="${element.id}">${element.nationality}</option>`)
            });
        }
    });
}

$('#passport').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("Passport UPLOADED");
})

$('#personalID').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("Personal ID UPLOADED");
})
$('#universityCertificate').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("University Certificate UPLOADED");
})

$('#nonCriminal').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html('Non-criminal Certificate UPLOADED');
})
$('#medicalCertificate').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("Medical Certificate UPLOADED");
})

$('#CV').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("CV UPLOADED");
})


$('#IBAN').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("IBAN UPLOADED");
})
$('#other').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("Document UPLOADED");
})

$('#recommendationLetter').on('change', function () {
    //get the file name
    var fileName = $(this).val();
    //replace the "Choose a file" label
    $(this).next('.custom-file-label').html("Recommendation Letter UPLOADED");
})
function getPositions() {
    var position_Select = $('#position');

    $.ajax({
        type: "POST",
        url: URI + '?action=getposition',
        dataType: "JSON",
        success: function (response) {
            data = response.data;
            data.forEach(element => {
                position_Select.append(`<option value="${element.id}">${element.position}</option>`)
            });
        }
    });
}
var myInput = document.getElementById("password");
var letter = document.getElementById("letter");
var capital = document.getElementById("capital");
var number = document.getElementById("number");
var length = document.getElementById("length");



// When the user clicks on the password field, show the message box
myInput.onfocus = function () {
    document.getElementById("message").style.display = "block";
}

// When the user clicks outside of the password field, hide the message box
myInput.onblur = function () {
    document.getElementById("message").style.display = "none";
}

// When the user starts to type something inside the password field
myInput.onkeyup = function () {
    // Validate lowercase letters
    var lowerCaseLetters = /[a-z]/g;
    if (myInput.value.match(lowerCaseLetters)) {
        letter.classList.remove("invalid");
        letter.classList.add("valid");
    } else {
        letter.classList.remove("valid");
        letter.classList.add("invalid");
    }

    // Validate capital letters
    var upperCaseLetters = /[A-Z]/g;
    if (myInput.value.match(upperCaseLetters)) {
        capital.classList.remove("invalid");
        capital.classList.add("valid");
    } else {
        capital.classList.remove("valid");
        capital.classList.add("invalid");
    }

    // Validate numbers
    var numbers = /[0-9]/g;
    if (myInput.value.match(numbers)) {
        number.classList.remove("invalid");
        number.classList.add("valid");
    } else {
        number.classList.remove("valid");
        number.classList.add("invalid");
    }

    // Validate length
    if (myInput.value.length >= 8) {
        length.classList.remove("invalid");
        length.classList.add("valid");
    } else {
        length.classList.remove("valid");
        length.classList.add("invalid");
    }
}



window.requestAnimFrame = (function (callback) {
    return window.requestAnimationFrame ||
        window.webkitRequestAnimationFrame ||
        window.mozRequestAnimationFrame ||
        window.oRequestAnimationFrame ||
        window.msRequestAnimaitonFrame ||
        function (callback) {
            window.setTimeout(callback, 1000 / 60);
        };
})();

var canvas = document.getElementById("sig-canvas");
var ctx = canvas.getContext("2d");
ctx.strokeStyle = "#222222";
ctx.lineWidth = 4;

var drawing = false;
var mousePos = {
    x: 0,
    y: 0
};
var lastPos = mousePos;

canvas.addEventListener("mousedown", function (e) {
    drawing = true;
    lastPos = getMousePos(canvas, e);
}, false);

canvas.addEventListener("mouseup", function (e) {
    drawing = false;
}, false);

canvas.addEventListener("mousemove", function (e) {
    mousePos = getMousePos(canvas, e);
}, false);

// Add touch event support for mobile
canvas.addEventListener("touchstart", function (e) {

}, false);

canvas.addEventListener("touchmove", function (e) {
    var touch = e.touches[0];
    var me = new MouseEvent("mousemove", {
        clientX: touch.clientX,
        clientY: touch.clientY
    });
    canvas.dispatchEvent(me);
}, false);

canvas.addEventListener("touchstart", function (e) {
    mousePos = getTouchPos(canvas, e);
    var touch = e.touches[0];
    var me = new MouseEvent("mousedown", {
        clientX: touch.clientX,
        clientY: touch.clientY
    });
    canvas.dispatchEvent(me);
}, false);

canvas.addEventListener("touchend", function (e) {
    var me = new MouseEvent("mouseup", {});
    canvas.dispatchEvent(me);
}, false);

function getMousePos(canvasDom, mouseEvent) {
    var rect = canvasDom.getBoundingClientRect();
    return {
        x: mouseEvent.clientX - rect.left,
        y: mouseEvent.clientY - rect.top
    }
}

function getTouchPos(canvasDom, touchEvent) {
    var rect = canvasDom.getBoundingClientRect();
    return {
        x: touchEvent.touches[0].clientX - rect.left,
        y: touchEvent.touches[0].clientY - rect.top
    }
}

function renderCanvas() {
    if (drawing) {
        ctx.moveTo(lastPos.x, lastPos.y);
        ctx.lineTo(mousePos.x, mousePos.y);
        ctx.stroke();
        lastPos = mousePos;
    }
}

// Prevent scrolling when touching the canvas
document.body.addEventListener("touchstart", function (e) {
    if (e.target == canvas) {
        e.preventDefault();
    }
}, false);
document.body.addEventListener("touchend", function (e) {
    if (e.target == canvas) {
        e.preventDefault();
    }
}, false);
document.body.addEventListener("touchmove", function (e) {
    if (e.target == canvas) {
        e.preventDefault();
    }
}, false);

(function drawLoop() {
    requestAnimFrame(drawLoop);
    renderCanvas();
})();

function clearCanvas() {
    canvas.width = canvas.width;
}

// Set up the UI
var sigText = document.getElementById("sig-dataUrl");
var sigImage = document.getElementById("sig-image");
var clearBtn = document.getElementById("sig-clearBtn");
var submitBtn = document.getElementById("sig-submitBtn");
clearBtn.addEventListener("click", function (e) {
    clearCanvas();
    sigText.innerHTML = "Data URL for your signature will go here!";
    sigImage.setAttribute("src", "");
}, false);
submitBtn.addEventListener("click", function (e) {
    var dataUrl = canvas.toDataURL();
    sigText.innerHTML = dataUrl;
    sigImage.setAttribute("src", dataUrl);

}, false);

